<?php


$servername = "localhost";
$username = "root";
$password = "";
$dbname = "requests";

$school = $_GET['school'];

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "";
switch ($schoolSelect) {
    case 'main':
        $sql = "SELECT semester, year FROM main LIMIT 1";
        break;
    case 'seaviewknd':
        $sql = "SELECT semester, year FROM seavieweekend LIMIT 1";
        break;
    case 'kccwknd':
        $sql = "SELECT semester, year FROM kccweekend LIMIT 1";
        break;
}

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $response = [
        'semester' => htmlspecialchars($row['semester']),
        'year' => htmlspecialchars($row['year'])
    ];
} else {
    $response = [
        'semester' => '',
        'year' => ''
    ];
}

$conn->close();

header('Content-Type: application/json');
echo json_encode($response);
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Conditional Display Form with Data Fetching</title>
    <style>
        .hidden {
            display: none;
        }
    </style>
</head>
<body>
    <div class='grid lg:grid-cols-4 px-12'>
        <div class=' grid-rows-2'>
            <div class='grid-rows-1'>
                <label>Select Your School:</label>
            </div>
            <div class='grid-rows-2'>
                <select id="schoolSelect" name='showsem' class='border-b-2 pr-12 border-2 border-gray-700 rounded-md min-w-[60%] focus:outline-blue-800 py-1 px-2'>
                    <option value=""> --Select--</option>
                    <option value='main'>Main School</option>
                    <option value='seaviewknd'>Seaview Weekend</option>
                    <option value='kccwknd'>KCC Weekend</option>
                </select>
            </div>
        </div>
        <div class=' grid-rows-2'>
            <div class='grid-rows-1'>
                <label>Current Level:</label>
            </div>
            <div class='grid-rows-2'>
                <select name='clevel' class='border-b-2 pr-12 border-2 border-gray-700 rounded-md min-w-[60%] focus:outline-blue-800 py-1 px-2'>
                    <option> --Select--</option>
                    <option value='l100'>100</option>
                    <option value='l200'>200</option>
                    <option value='l300'>300</option>
                    <option value='l400'>400</option>
                    <option value='masters'>Masters</option>
                    <option value='phd'>PhD</option>
                </select>
            </div>
        </div>
        <div class='grid-rows-2 hidden' id="selectSemester">
            <div class='grid-rows-1'>
                <label>Current Semester/Trimester</label>
            </div>
            <div class='grid-rows-2'>
                <input id="semesterInput" name='csem' class='border-b-2 pr-12 border-2 border-gray-700 rounded-md min-w-[60%] focus:outline-blue-800 py-1 px-2 bg-sky-100' disabled/>
            </div>
        </div>
        <div class='grid-rows-2 hidden' id="selectYear">
            <div class='grid-rows-1'>
                <label>Current Academic Year</label>
            </div>
            <div class='grid-rows-2'>
                <input id="yearInput" name='acdyr' class='border-2 border-gray-700 rounded-md focus:outline-blue-800 py-1 px-2 bg-sky-100' disabled />
            </div>
        </div>
    </div>
    <script>
        document.getElementById('schoolSelect').addEventListener('change', function() {
            var school = this.value;
            var semesterField = document.getElementById('selectSemester');
            var yearField = document.getElementById('selectYear');

            if (school) {
                fetch('fetch_school_data.php?school=' + school)
                    .then(response => response.json())
                    .then(data => {
                        document.getElementById('semesterInput').value = data.semester;
                        document.getElementById('yearInput').value = data.year;
                        semesterField.classList.remove('hidden');
                        yearField.classList.remove('hidden');
                    })
                    .catch(error => console.error('Error fetching data:', error));
            } else {
                semesterField.classList.add('hidden');
                yearField.classList.add('hidden');
            }
        });
    </script>
</body>
</html>
?>