<?php
error_reporting(E_ALL);
// PHPMailer('display_errors', 1);
require '../vendor/autoload.php';

// Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;


require_once './config.php';
// require_once 'mailer.php';

$action = $_GET['action'];

if ($action == 'staffLogin') {
  

    //check if the form is submitted
    if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['username']) && isset($_POST['password'])) {
        $username = $_POST['username'];
        $password = $_POST['password'];

        // Retrieve user with the provided username
        $query = "SELECT * FROM tbl_requests_officers WHERE username = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            // No user found with the provided username
            echo json_encode(["state" => 0, "message" => "Invalid username."]);
        } else {
            $user = $result->fetch_assoc();
            // Compare password
            if (password_verify($password, $user['password'])) {
                // Passwords match
           

                $_SESSION['user_id'] = $user['id'];
                $_SESSION['role'] = $user['role'];


                // Redirect user based on role
                switch ($_SESSION['role']) {
                    case 'IDU':
                        // echo "Redirecting to IDU page";
                        header("Location: ../../Frontend/Admin/AdminCardUnit.php");
                        exit();
                    case 'DFA':
                        // echo "Redirecting to Finance page";
                        header("Location: ../../Frontend/Admin/AdminDash.php");
                        exit();
                    case 'Registrar':
                        // echo "Redirecting to Registrar page";
                        header("Location: ../../Frontend/Admin/registrar.php");
                        exit();
                    default:
                        // Handle default case
                        echo 'INVALID CREDENTIALS';
                        echo json_encode(["state" => 0, "message" => "Invalid role."]);
                }
            }

            
            else {
                // Passwords do not match
                // echo json_encode(["state" => 0, "message" => "Incorrect password."]);
                echo json_encode ("Incorrect password.");
            }

            // print_r($user);
            // echo '<script>alert("' . password_verify($password, $user['password']) . '")</script>';
        }
        $stmt->close();
    }
}

if ($action == 'staffRegister') {
    extract($_POST);


    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    $query = "INSERT INTO tbl_requests_officers (officer_name, role, mail, username, password) VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($query);

    // Assuming $officer_name, $role, $mail, $username, and $hashedPassword are already defined
    $stmt->bind_param("sssss", $officer_name, $role, $mail, $username, $hashedPassword);

    if ($stmt->execute()) {
        echo '
            <script>
                alert("User created successfully here.")
                location.href="../../Frontend/Admin/Register.php";
            </script>
        ';
    } else {
        echo "Error creating user.";
    }

    $stmt->close();
    $conn->close();

}

// if ($action == 'IDCardRenewal') {

//     extract($_POST);
//     //image upload
//     $uploadDirectory = '../uploads/'; // Directory to save uploaded files
//     $uploadedFileName = $_FILES['image']['name'];
//     $uploadedFilePath = $uploadDirectory . (new DateTime())->format('Y-m-d-h-m-s') . $uploadedFileName;

//     if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadedFilePath)) {
//         //ID Generation
//         $customText = 'Card-';
//         $rqst_id = $customText . substr(uniqid(), 0, 6);


//         $DateApplied = (new DateTime())->format('Y-m-d');


//         $mail = new PHPMailer(true);
//         $mail->isSMTP();
//         $mail->Host = 'smtp.gmail.com';
//         $mail->SMTPAuth = true;
//         $mail->Username = 'devselasi@gmail.com';
//         $mail->Password = '$<l@$!2001';
//         $mail->SMTPSecure = 'tls';
//         $mail->Port = 587;
//         $mail->to = $email;
//         // $mail->from = "devselasi@gmail.com";


//         $mail->setFrom('devselasi@gmail.com', 'AIT Marketplace');
//         $mail->addAddress($email);

//         //Mailing


//         $mail->subject = 'Your Request ID';
//         $mail->Body = 'Dear user, <br><br>Your request ID is: ' . $rqst_id . '<br><br>Thank you for your request.';
//         $mail->headers = "From: agbesipreciousselasi@gmail.com\r\n";
//         // $headers .= "Content-type: text/html\r\n";





//         //Inserting Data
//         $query = "INSERT INTO card_tbl (stuid, rqst_id, campus, service, email, image, DateApplied, status) VALUES (?,?,?,?,?,?,?, 'pending')";
//         $stmt = $conn->prepare($query);

//         $stmt->bind_param("sssssss", $stuid, $rqst_id, $campus, $service, $email, $uploadedFilePath, $DateApplied);

//         if ($stmt->execute()) {
//             // Send the email only if the data is inserted successfully
//             if ($mail->send()) {
//                 echo '
//             <script>
//             alert("Info has been added and your Request ID has been sent to your email.");
//             location.href="../../Frontend/Client/NewRequest.php";
//             </script>';
//             } else {
//                 echo "Error: " . $stmt->error;
//             }

//             $stmt->close();
//             $conn->close();

//         }

//     }
// }



if ($action == 'IDCardRenewal') {
    extract($_POST);

    //inserts  date of the request in to the database. 
    $created_at = date('Y-m-d');


    // Check if image file is uploaded
    if (isset($_FILES['image']) && $_FILES['image']['error'] == UPLOAD_ERR_OK) {
        $uploadDirectory = '../uploads/'; // Directory to save uploaded files
        $uploadedFileName = $_FILES['image']['name'];
        $uploadedFilePath = $uploadDirectory . (new DateTime())->format('Y-m-d-H-i-s') . '-' . $uploadedFileName;


        function generateRandomString($length)
        {
            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $randomString = '';
            for ($i = 0; $i < $length; $i++) {
                $randomString .= $characters[rand(0, strlen($characters) - 1)];
            }
            return $randomString;
        }

        // Move the uploaded file
        if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadedFilePath)) {
            // ID Generation
            $customText = 'Card-';
            $rqst_id = $customText . generateRandomString(5);
            $_SESSION['status'] = $rqst_id;

            // Initialize PHPMailer
            $mail = new PHPMailer(true);

            try {
                // Server settings
                $mail->isSMTP();
                $mail->Host = 'smtp.gmail.com';
                $mail->SMTPAuth = true;
                $mail->Username = 'devselasi@gmail.com'; // SMTP username
                $mail->Password = 'oriqgvrzzoecjmtc'; // SMTP password
                $mail->SMTPSecure = 'tls'; // Enable TLS encryption
                $mail->Port = 587; // TCP port to connect to

                // Recipients
                $mail->setFrom('devselasi@gmail.com', 'AIT Marketplace');
                $mail->addAddress($email);
                // $mail->to = $email;

                // Content
                $mail->isHTML(true); // Set email format to HTML
                $mail->Subject = 'Your AIT Market Place Transaction Request ID';
                $mail->Body = '
                                Dear Student, <br><br>You have applied for an ID Card Renewal/Replacement on the AIT Marketplace. 
                                Your request ID is: ' . $rqst_id . '<br><br>Use this request ID to track your request.
                               <br>Click <a href="http://localhost/marketplace/Frontend/Client/Activity.php?stuid=' . $stuid . '&rqst_id=' . $rqst_id . '"> here</a> to go to the portal to track your request.
                
                ';
                $mail->AltBody = 'Dear Student, \n\nYour request ID is: ' . $rqst_id . '\n\nThank you for your request.';

                // Inserting Data into Database
                $query = "INSERT INTO card_tbl (stuid, rqst_id, campus, service, email, image, created_at, status) VALUES (?,?,?,?,?,?,?, 'pending')";
                $stmt = $conn->prepare($query);

                $stmt->bind_param("sssssss", $stuid, $rqst_id, $campus, $service, $email, $uploadedFilePath, $created_at);

                if ($stmt->execute()) {
                    // Send the email only if the data is inserted successfully
                    if ($mail->send()) {
                        echo '<script>
                        alert("Info has been added and your Request ID has been sent to your email.");
                        location.href="../../Frontend/Client/NewRequest.php";
                        </script>';
                    } else {
                        echo "Mailer Error: " . $mail->ErrorInfo;
                    }
                } else {
                    echo "Database Error: " . $stmt->error;
                }

                $stmt->close();
            } catch (Exception $e) {
                echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
            }
        } else {
            echo "Failed to move uploaded file.";
        }
    } else {
        echo "No file uploaded or there was an upload error.";
    }

    $conn->close();
}

if ($action == 'introductoryLetter') {
    $uploadDirectory = '../uploads/';
    $uploadedFileName = $_FILES['receipt_path']['name'];
    $uploadedFilePath = $uploadDirectory . (new DateTime())->format('Y-m-d-h-m-s') . $uploadedFileName;



    extract($_POST);
    if (move_uploaded_file($_FILES['receipt_path']['tmp_name'], $uploadedFilePath)) {
        // File successfully uploaded, proceed with database insertion
        // $customText = '-INTRO-';
        // $rqst_id = $stuid . $customText . substr(uniqid(), 0, 6);

        // Initialize PHPMailer
        $mail = new PHPMailer(true);
        // Generating rqst ID

        extract($_POST);
        function generateRandomString($length)
        {
            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $randomString = '';
            for ($i = 0; $i < $length; $i++) {
                $randomString .= $characters[rand(0, strlen($characters) - 1)];
            }
            return $randomString;
        }
        $rqst_id = $stuid . '-INTRO-' . generateRandomString(5);

        $created_at = date('Y-m-d');

        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'devselasi@gmail.com'; // SMTP username
            $mail->Password = 'oriqgvrzzoecjmtc'; // SMTP password
            $mail->SMTPSecure = 'tls'; // Enable TLS encryption
            $mail->Port = 587; // TCP port to connect to

            // Recipients
            $mail->setFrom('devselasi@gmail.com', 'AIT Marketplace');
            $mail->addAddress($email);

            $mail->isHTML(true); // Set email format to HTML
            $mail->Subject = 'Your Introductory Letter Request ID';
            $mail->Body = 'Dear Student, <br><br>Your request ID is: ' . $rqst_id . '<br><br>Use this request ID to track your request';
            $mail->AltBody = 'Dear Student, \n\nYour request ID is: ' . $rqst_id . '\n\nThank you for your request.';


            $query = "INSERT INTO tbl_introductory_requests (rqst_id, stuid, name, nationality, phone, email, purpose, raddress, bname, pnumber, eaddress, receipt_path, delivery, created_at, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'Pending')";
            $stmt = $conn->prepare($query);



            // Bind parameters
            $stmt->bind_param('sssissssssssss', $rqst_id, $stuid, $name, $nationality, $phone, $email, $purpose, $raddress, $bname, $pnumber, $eaddress, $uploadedFilePath, $delivery, $created_at);

            if ($stmt->execute()) {
                echo '<script>alert("Request made successfully.");
                location.href="../../Frontend/Client/NewRequest.php";
                </script>';
            } else {
                echo "Error creating request.";
            }

            $stmt->close();
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
        $conn->close();
    }
}

if ($action == 'defermentApplication') {
    // Processing uploaded file
    $uploadDirectory = '../uploads/'; // Directory to save uploaded files
    $uploadedFileName = $_FILES['receipt_path']['name'];
    $uploadedFilePath = $uploadDirectory . (new DateTime())->format('Y-m-d-h-m-s') . $uploadedFileName;

    if (move_uploaded_file($_FILES['receipt_path']['tmp_name'], $uploadedFilePath)) {
        // File uploaded successfully, continue with database insertion


        // Extracting form data
        extract($_POST);

        $created_at = (new DateTime())->format('Y-m-d');


        try {
            $mail = new PHPMailer(true);
            // Server settings
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'devselasi@gmail.com'; // SMTP username
            $mail->Password = 'oriqgvrzzoecjmtc'; // SMTP password
            $mail->SMTPSecure = 'tls'; // Enable TLS encryption
            $mail->Port = 587; // TCP port to connect to

            // Recipients
            $mail->setFrom('devselasi@gmail.com', 'AIT Marketplace');
            $mail->addAddress($email);

            $query = "INSERT INTO tbl_deferments (rqst_id, stuid, phone, clevel, csem, email, defsem, academicyear, retsem, retyear, reason, reason_specify, created_at, receipt_path, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'Pending')";
            $stmt = $conn->prepare($query);

            // Generating request ID
            function generateRandomString($length)
            {
                $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $randomString = '';
                for ($i = 0; $i < $length; $i++) {
                    $randomString .= $characters[rand(0, strlen($characters) - 1)];
                }
                return $randomString;
            }
            $rqst_id = $stuid . '-DEF-' . generateRandomString(5);

            $mail->Subject = 'Your Request ID';
            $mail->Body = 'Dear Student, <br><br>Your request ID is: ' . $rqst_id . '<br><br>Use this request ID to track your request';
            $mail->AltBody = 'Dear Student, \n\nYour request ID is: ' . $rqst_id . '\n\nThank you for your request.';


            $stmt->bind_param('ssssisisisssss', $rqst_id, $stuid, $phone, $clevel, $csem, $email, $defsem, $academicyear, $retsem, $retyear, $reason, $reason_specify, $created_at, $uploadedFilePath);

            if ($stmt->execute()) {
                // Send the email only if the data is inserted successfully
                if ($mail->send()) {
                    echo '<script>
                    alert("Info has been added and your Request ID has been sent to your email.");
                    location.href="../../Frontend/Client/NewRequest.php";
                    </script>';
                } else {
                    echo "Mailer Error: " . $mail->ErrorInfo;
                }
            } else {
                echo "Database Error: " . $stmt->error;
            }

            $stmt->close();
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        } {
            echo "Error uploading file";
        }
    }

    $conn->close();
}

if ($action == 'certificateApplication') {
    // Processing uploaded file
    $uploadDirectory = '../uploads/'; // Directory to save uploaded files
    $uploadedFileName = $_FILES['receipt_path']['name'];
    $uploadedFilePath = $uploadDirectory . (new DateTime())->format('Y-m-d-h-m') . $uploadedFileName;

    if (move_uploaded_file($_FILES['receipt_path']['tmp_name'], $uploadedFilePath)) {
        // File uploaded successfully, continue with database insertion


        // Initialize PHPMailer
        $mail = new PHPMailer(true);
        // Extracting form data
        extract($_POST);

        $created_at = (new DateTime())->format('Y-m-d');

        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'devselasi@gmail.com'; // SMTP username
            $mail->Password = 'oriqgvrzzoecjmtc'; // SMTP password
            $mail->SMTPSecure = 'tls'; // Enable TLS encryption
            $mail->Port = 587; // TCP port to connect to

            // Recipients
            $mail->setFrom('devselasi@gmail.com', 'AIT Marketplace');
            $mail->addAddress($email);

            $mail->isHTML(true); // Set email format to HTML


            $query = "INSERT INTO tbl_certificate (rqst_id, stuid, name, prog, level, phone, delivery, email, postal, physicaladd, created_at, receipt) VALUES (?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)";
            $stmt = $conn->prepare($query);

            // Generating request ID
            function generateRandomString($length)
            {
                $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $randomString = '';
                for ($i = 0; $i < $length; $i++) {
                    $randomString .= $characters[rand(0, strlen($characters) - 1)];
                }
                return $randomString;
            }
            $rqst_id = $stuid . '-CERT-' . generateRandomString(5);

            $mail->Subject = 'Your Certificate Application Request ID ';
            $mail->Body = 'Dear Student, <br><br>Your request ID is: ' . $rqst_id . '<br><br>Use this to track your request. <br>Click <a href="http://localhost/marketplace/Frontend/Client/userindex.php"> here</a> to go to the portal to track your request.';
            $mail->AltBody = 'Dear Student, \n\nYour request ID is: ' . $rqst_id . '\n\nThank you for your request.';



            $stmt->bind_param('ssssssssssss', $rqst_id, $stuid, $name, $prog, $level, $phone, $delivery, $email, $postal, $physicaladd, $created_at, $uploadedFilePath);

            if ($stmt->execute()) {
                // Send the email only if the data is inserted successfully
                if ($mail->send()) {
                    echo '<script>
            alert("Info has been added and your Request ID has been sent to your email.");
            location.href="../../Frontend/Client/NewRequest.php";
            </script>';
                } else {
                    echo "Mailer Error: " . $mail->ErrorInfo;
                }
            } else {
                echo "Database Error: " . $stmt->error;
            }

            $stmt->close();
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        } {
            echo "Error uploading file";
        }
    }

    $conn->close();
}

if ($action == 'transcriptApplication') {
    // Processing uploaded file
    $uploadDirectory = '../uploads/'; // Directory to save uploaded files
    $uploadedFileName = $_FILES['receipt_path']['name'];
    $uploadedFilePath = $uploadDirectory . (new DateTime())->format('Y-m-d-h-m-s') . $uploadedFileName;

    if (move_uploaded_file($_FILES['receipt_path']['tmp_name'], $uploadedFilePath)) {
        // File uploaded successfully, continue with database insertion


        $mail = new PHPMailer(true);
        // Extracting form data
        extract($_POST);

        $created_at = (new DateTime())->format('Y-m-d');

        try {
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'devselasi@gmail.com'; // SMTP username
            $mail->Password = 'oriqgvrzzoecjmtc'; // SMTP password
            $mail->SMTPSecure = 'tls'; // Enable TLS encryption
            $mail->Port = 587; // TCP port to connect to

            // Recipients
            $mail->setFrom('devselasi@gmail.com', 'AIT Marketplace');
            $mail->addAddress($email);

            $mail->isHTML(true); // Set email format to HTML

            $query = "INSERT INTO tbltranscript_requests (rqst_id, stuid, name, email, level, prog, phone, purpose, period, ogname, ogcontact, ogphone, ogemail, ogpostal, created_at, deliv_mode, mode_specify, receipt_path) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
            $stmt = $conn->prepare($query);

            // Generating request ID
            function generateRandomString($length)
            {
                $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $randomString = '';
                for ($i = 0; $i < $length; $i++) {
                    $randomString .= $characters[rand(0, strlen($characters) - 1)];
                }
                return $randomString;
            }

            $rqst_id = $stuid . '-TRANS-' . generateRandomString(5);

            // Function to generate random string of specified length

            $stmt->bind_param('ssssssssssssssssss', $rqst_id, $stuid, $name, $email, $level, $prog, $phone, $purpose, $period, $ogname, $ogcontact, $ogphone, $ogemail, $ogpostal, $created_at, $deliv_mode, $mode_specify, $uploadedFilePath);
            $mail->Subject = 'Your Transcript Application Request ID ';
            $mail->Body = 'Dear Student, <br><br>Your request ID is: ' . $rqst_id . '<br><br>Use this to track your request.';
            $mail->AltBody = 'Dear Student, \n\nYour request ID is: ' . $rqst_id . '\n\nThank you for your request.';


            if ($stmt->execute()) {
                echo '
                <script>
                    alert("Info has successfully been added");
                    location.href="../../Frontend/Client/NewRequest.php";
                </script>';
            } else {
                echo "Error: " . $stmt->error;
            }

            $stmt->close();
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        } {
            echo "Error uploading file";
        }
    }

    $conn->close();
}